<?php

namespace AdminBundle\Controller;

use AdminBundle\Entity\Contact;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

class DashboardController extends Controller
{
    /**
     * @Route("/", name="admin_home")
     * @Method("GET")
     * @Template("AdminBundle:Dashboard:index.html.twig")
     */
    public function indexAction()
    {
        $contactRepository = $this->get('contact_repository');
        return array(
            'active' => $contactRepository->findAllActive(),
            'archived' => $contactRepository->findAllArchived()
        );
    }

    /**
     * @Route("/admin/contact/{id}/delete", name="admin_contact_delete")
     * @ParamConverter(name="contact", class="AdminBundle\Entity\Contact")
     * @Method("GET")
     */
    public function deleteContactAction(Contact $contact)
    {
        $entityManager = $this->get('doctrine.orm.entity_manager');
        $entityManager->remove($contact);
        $entityManager->flush();

        return $this->redirect($this->generateUrl('admin_home'));
    }

    /**
     * @Route("/admin/contact/{id}/archive", name="admin_contact_archive")
     * @ParamConverter(name="contact", class="AdminBundle\Entity\Contact")
     * @Method("GET")
     */
    public function archiveContactAction(Contact $contact)
    {
        $contact->setArchived(true);

        $entityManager = $this->get('doctrine.orm.entity_manager');
        $entityManager->flush();

        return $this->redirect($this->generateUrl('admin_home'));
    }
}
