<?php
namespace AdminBundle\Form\Type;


use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CategoryFormType extends AbstractType {

    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder->add('id', 'hidden');
        $builder->add('slug', 'text', array(
            'label' => 'Slug (pour affichage dans URL, ex: motion-design)',
            'required' => true
        ));
        $builder->add('label', 'text', array(
            'label' => 'Label',
            'required' => true
        ));
        $builder->add('position', 'text', array(
            'label' => 'Position',
            'required' => true
        ));
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => "AdminBundle\Entity\Category"
        ));
    }

    public function getName()
    {
        return 'admin_category_form';
    }

}