<?php

namespace AdminBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class StudioFormType extends AbstractType {

    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder->add('language', 'entity', array(
            'class' => 'AdminBundle:Language',
            'choice_label' => 'label',
            'disabled' => true
        ));
        $builder->add('video', 'text', array(
            'required' => true,
            'label' => 'Video link'
        ));
        $builder->add('content', 'textarea', array(
            'required' => true,
            'label' => 'Content'
        ));
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => "AdminBundle\Entity\Studio"
        ));
    }

    public function getName()
    {
        return 'admin_studio_form';
    }

}