<?php

namespace AppBundle\Controller;

use AdminBundle\Entity\Contact;
use AppBundle\Form\Type\ContactFormType;
use AppBundle\Form\Handler\ContactFormHandler;
use AppBundle\Helper\LocaleHelper;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class HomeController extends Controller
{
    /**
     * @Route("/", name="app_home")
     * @Method("GET")
     * @Template()
     */
    public function indexAction(Request $request)
    {
        LocaleHelper::initLocale($request);
        return $this->get('project_service')->presentProjects($request->getSession()->get('_locale'));
    }


    /**
     * @Route("/contact", name="app_contact")
     * @Method({"GET","POST"})
     * @Template()
     */
    public function contactAction(Request $request) {
        LocaleHelper::initLocale($request);

        $form = $this->createForm(new ContactFormType(), new Contact());
        $form->handleRequest($request);

        $handler = new ContactFormHandler($form, $request, $this->container);
        if($form->isValid() && $handler->process()) {
            $translator = $this->get('translator');
            $this->get('session')->getFlashBag()->add('success', $translator->trans('CONTACT_SUCCESS_MSG'));
            return $this->redirect($this->generateUrl('app_studio'));
        }
        return array('form' => $form->createView());
    }

    /**
     * @Route("/studio", name="app_studio")
     * @Method("GET")
     * @Template()
     */
    public function studioAction(Request $request) {
        LocaleHelper::initLocale($request);
        $language = $request->getSession()->get('_locale');

        $repository = $this->get('studio_repository');
        $studio = $repository->findOneByLanguage(!isset($language) ? 'fr' : $language);

        return array('studio' => $studio);
    }

    /**
     * @Template()
     */
    public function translationAction() {
        return array();
    }



}
